/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.ZipTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"unzip"})
public class Unzip
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(Unzip.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;

    public void run(String ... arg0) {
        String prefix = "[Unzip]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[Unzip]", (Object)this.loadFolder);
            int count = 0;
            for (Path file : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
                ++count;
                Instant start = Instant.now();
                Path unzipFolder = Paths.get(file.toString() + "_extracted", new String[0]);
                try {
                    FileTool.ensureFolderExists((Path)unzipFolder);
                    ZipTool zipFile = new ZipTool(file.toUri());
                    if (!zipFile.unzipFiles(unzipFolder, true)) {
                        log.error("{} Unzipping error {}", (Object)"[Unzip]", (Object)file);
                    }
                }
                catch (Exception e) {
                    log.error("{} Error in unzipping {}", new Object[]{"[Unzip]", file, e});
                }
                Instant finish = Instant.now();
                log.info("{} Extraction duration of {}: {}s", new Object[]{"[Unzip]", file, Duration.between(start, finish).getSeconds()});
            }
            log.info("{} Unzip process of {} : {} processed file(s)", new Object[]{"[Unzip]", this.loadFolder, count});
        }
    }
}

