/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.XMLTool;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"xml2json"})
public class Xml2Json
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(Xml2Json.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;

    public void run(String ... arg0) {
        String prefix = "[XML2JSON]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[XML2JSON]", (Object)this.loadFolder);
            int count = 0;
            for (Path file : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
                if (!file.getFileName().toString().endsWith(".xml")) continue;
                ++count;
                Instant start = Instant.now();
                String jsonFile = file.getParent().toString() + File.separatorChar + file.getFileName().toString().replaceFirst(".xml", ".json");
                try {
                    log.info("{} XML {} validation", (Object)"[XML2JSON]", (Object)file);
                    XMLTool.wellformed((Path)file);
                    log.info("{} XML {} conversion in JSON", (Object)"[XML2JSON]", (Object)file);
                    JSONObject json = XMLTool.xml2Json((String)FileTool.toString((Path)file));
                    log.info("{} JSON {} save in {}", new Object[]{"[XML2JSON]", file, jsonFile});
                    try (PrintWriter out = new PrintWriter(jsonFile);){
                        out.println(json);
                    }
                }
                catch (Exception e) {
                    log.error("{} XML {}", new Object[]{"[XML2JSON]", file, e});
                }
                Instant finish = Instant.now();
                log.info("{} XML {} procession duration: {}s", new Object[]{"[XML2JSON]", file, Duration.between(start, finish).getSeconds()});
            }
            log.info("{} Conversion process {} : {} processed XML(s)", new Object[]{"[XML2JSON]", this.loadFolder, count});
        }
    }
}

