/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools.common;

import ch.dlcm.model.preingest.DepositDataFile;
import ch.dlcm.tools.common.DLCMTools;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepositPurger
extends DLCMTools {
    private static final Logger log = LoggerFactory.getLogger(DepositPurger.class);

    public DepositPurger(StandaloneRestClientTool restClientTool, String preIngestUrl) {
        super(restClientTool);
        this.preIngestUrl = preIngestUrl;
    }

    public int deleteDepositDatafiles(String prefix, String depositId, String relativeLocation) {
        int error = 0;
        int fileTotal = 0;
        int dfTotal = 0;
        if (!relativeLocation.startsWith("/")) {
            log.error("{} Relative location {} must start with a '/'", (Object)prefix, (Object)relativeLocation);
            return 0;
        }
        List dataFileList = this.findDataFiles(depositId, relativeLocation.substring(1));
        dfTotal += dataFileList.size();
        for (DepositDataFile dataFile : dataFileList) {
            log.info("{} Purge deposit data file: {}, {}/{}", new Object[]{prefix, dataFile.getResId(), dataFile.getRelativeLocation(), dataFile.getFileName()});
            if (this.deleteDataFile(depositId, dataFile.getResId())) {
                ++fileTotal;
                continue;
            }
            ++error;
        }
        log.info("{} Data files purge for deposit {} : {}  error(s), {} file(s), {} data file(s)", new Object[]{prefix, depositId, error, fileTotal, dfTotal});
        return fileTotal;
    }

    public List<String> listFolders(String prefix, String depositId) {
        try {
            return this.findFolders(depositId);
        }
        catch (Exception e) {
            log.error("{} Error in getting folders list: {}", (Object)prefix, (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }
}

